<?php

declare(strict_types=1);

namespace Erlage\Photogram\Exceptions;

use Erlage\Photogram\Constants\ResponseConstants;
use Exception;
use Erlage\Photogram\SystemLogger;

final class ServerException extends Exception
{
    public function __construct(string $message = ResponseConstants::ERROR_FAILED_REQUEST_MSG)
    {
        parent::__construct($message);

        SystemLogger::serverException($this);
    }
}
